document.getElementById('start-button').addEventListener('click', startGame);
document.getElementById('continue-button').addEventListener('click', continueGame);
document.getElementById('save-button').addEventListener('click', saveGame);
document.getElementById('initial-play-button').addEventListener('click', showTitleScreen);

let currentBGM = '';
let bgmPosition = 0;
let bgmElement = document.getElementById('bgm');

// タイトル画面のBGMパス
const titleBGM = './data/bgm/事件を考察【大同高校⧸Original BGM】.mp3';

// 変数管理オブジェクト
let gameVariables = {
    scene1VisitedCount: 0,
    scene2VisitedCount: 0,
    scene3VisitedCount: 0,
    scene4VisitedCount: 0,
    scene5VisitedCount: 0,
    scene6VisitedCount: 0,
};

// スイッチ管理オブジェクト
let switches = {
    '泥': false,
    'あ': false,
    'ソフトウェア室棚': false,
    '南館a': false,
    'K22': false,
    'K221': false,
};

// 現在のシーンIDをグローバルに保持
let currentSceneId = 0;

// ゲーム開始時にセーブデータの有無を確認し、Continueボタンを有効化
window.onload = function () {
    const savedData = localStorage.getItem('gameSave');
    if (savedData) {
        document.getElementById('continue-button').disabled = false;
    }
};

function showTitleScreen() {
    document.getElementById('initial-screen').style.display = 'none';
    document.getElementById('title-screen').style.display = 'block';
    changeBGM(titleBGM);
}

function startGame() {
    document.getElementById('title-screen').style.display = 'none';
    document.getElementById('game-screen').style.display = 'block';
    showScene(0); 
}

function continueGame() {
    const savedData = JSON.parse(localStorage.getItem('gameSave'));
    if (savedData) {
        document.getElementById('title-screen').style.display = 'none';
        document.getElementById('game-screen').style.display = 'block';
        gameVariables = savedData.gameVariables;
        switches = savedData.switches;
        showScene(savedData.sceneId);
    }
}

function saveGame() {
    const saveData = {
        sceneId: currentSceneId,
        gameVariables: gameVariables,
        switches: switches
    };
    localStorage.setItem('gameSave', JSON.stringify(saveData));
    document.getElementById('continue-button').disabled = false;
    alert('ゲームが保存されました！');
}

const scenes = [
    {
        "id": 0,
        "background": "",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "この作品は、ノベルジェネシス・パレットのサンプルゲームです。\n\n制作：ICT・プログラミング部 初代部長",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 1
            }
        ]
    },
    {
        "id": 1,
        "background": "./data/img/background/校舎-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "これは、私が働き始めたばかりの頃の話である。",
        "bgm": "./data/bgm/ベルとクワイヤ(コーラス)が中心の不気味で重たいホラー曲【ホラー 不気味 BGM】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 2
            }
        ]
    },
    {
        "id": 2,
        "background": "./data/img/background/校舎-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "この学校は怪奇現象がよく起きていた。",
        "bgm": "./data/bgm/ベルとクワイヤ(コーラス)が中心の不気味で重たいホラー曲【ホラー 不気味 BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 3
            }
        ]
    },
    {
        "id": 3,
        "background": "scene3.jpg",
        "defaultLeftCharacter": "character2.png",
        "defaultCenterCharacter": "character-center.png",
        "defaultRightCharacter": "character3.png",
        "dialogue": "",
        "bgm": "./data/bgm/",
        "sfx": "sfx3.mp3",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 4
            }
        ]
    },
    {
        "id": 4,
        "background": "",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "それは、私が残業していた時だった",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 5
            }
        ]
    },
    {
        "id": 5,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "（あ〜、やっと採点終わった）",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/本.m4a",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 6
            }
        ]
    },
    {
        "id": 6,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "もう21時か、\nそろそろ帰るか…",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 7
            }
        ]
    },
    {
        "id": 7,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "あ、しまった。教室に忘れ物したな。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 8
            }
        ]
    },
    {
        "id": 8,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "当然だが真っ暗だ",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 9
            }
        ]
    },
    {
        "id": 9,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": ".....めんどくさいけど、、、取りに行くか。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 10
            }
        ]
    },
    {
        "id": 10,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "えーっと、、、クラスがF22…           \nあれ？",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 11
            }
        ]
    },
    {
        "id": 11,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "鍵が無い！？        ",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 12
            }
        ]
    },
    {
        "id": 12,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "職員室の中を探すも、鍵は見つからなかった。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 13
            }
        ]
    },
    {
        "id": 13,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "、、、、      探すか…     ",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 14
            }
        ]
    },
    {
        "id": 14,
        "background": "./data/img/background/本館マップ-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "             ",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 15
            }
        ]
    },
    {
        "id": 15,
        "background": "./data/img/background/本館マップ-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "取りに行く鍵はF22、      \nおそらく他のクラスには無いから、探すとしたら多目的室かソフトウェア室か、南館か。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 16
            }
        ],
        "alternateScenes": {
            "泥": {
                "background": "./data/img/background/職員室-EDIT.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "結局見つからなかったな…     \n明日聞いてみるか…",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "",
                "textTickSFX": "./data/se/text-se/会話音１.m4a",
                "choices": [
                    {
                        "text": "次へ",
                        "nextScene": 46
                    }
                ]
            }
        }
    },
    {
        "id": 16,
        "background": "./data/img/background/本館廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "どっちに行こうか？",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "ソフトウェア室",
                "nextScene": 17
            },
            {
                "text": "多目的室",
                "nextScene": 29
            },
            {
                "text": "南館",
                "nextScene": 27
            }
        ]
    },
    {
        "id": 17,
        "background": "./data/img/background/部室前1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "本館3F：ソフトウェア室",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "入室",
                "nextScene": 18
            },
            {
                "text": "戻る",
                "nextScene": 15
            }
        ]
    },
    {
        "id": 18,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/引き戸.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 19
            }
        ]
    },
    {
        "id": 19,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "引き出しの中にありそうだな…     \n多分生徒用の引き出しには無いから、探るなら棚か教員用くらいか  ",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "教員用の引き出しを探る",
                "nextScene": 20
            },
            {
                "text": "棚を探る",
                "nextScene": 21
            },
            {
                "text": "退室",
                "nextScene": 17
            }
        ],
        "alternateScenes": {
            "あ": {
                "background": "./data/img/background/部室1-EDIT.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "ソフトウェア室か、どこを調べようか？",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "",
                "textTickSFX": "./data/se/text-se/会話音１.m4a",
                "choices": [
                    {
                        "text": "教員用の引き出しを探る",
                        "nextScene": 20
                    },
                    {
                        "text": "棚を探る",
                        "nextScene": 21
                    },
                    {
                        "text": "退室",
                        "nextScene": 17
                    }
                ]
            }
        }
    },
    {
        "id": 20,
        "background": "./data/img/background/PC教員引き出し-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/引き戸.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 22
            }
        ]
    },
    {
        "id": 21,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "棚はロックが掛かっている\n鍵の上に赤いシールが貼ってある。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/鍵付きのドア.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "戻る",
                "nextScene": 19
            }
        ],
        "alternateScenes": {
            "ソフトウェア室棚": {
                "background": "./data/img/background/部室1-EDIT.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "棚はロックが掛かっている\n鍵の上に赤いシールが貼ってある。",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "./data/se/鍵付きのドア.m4a",
                "textTickSFX": "",
                "choices": [
                    {
                        "text": "次へ",
                        "nextScene": 47
                    }
                ]
            }
        }
    },
    {
        "id": 22,
        "background": "./data/img/background/PC教員引き出し-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "うわ、散らかってる.......",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 23
            }
        ],
        "alternateScenes": {
            "あ": {
                "background": "./data/img/background/PC教員引き出し-EDIT.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "うわ、散らかってる.......",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "",
                "textTickSFX": "./data/se/text-se/会話音１.m4a",
                "choices": [
                    {
                        "text": "次へ",
                        "nextScene": 19
                    }
                ]
            }
        }
    },
    {
        "id": 23,
        "background": "./data/img/background/PC教員引き出し-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "中には南館渡り廊下と書かれた鍵がある。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 24
            }
        ]
    },
    {
        "id": 24,
        "background": "./data/img/background/PC教員引き出し-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "鍵を取りますか？",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/ピッ！.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "取る",
                "nextScene": 25
            },
            {
                "text": "今は取らない",
                "nextScene": 26
            }
        ]
    },
    {
        "id": 25,
        "background": "./data/img/background/PC教員引き出し-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "鍵を入手した。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 19
            }
        ]
    },
    {
        "id": 26,
        "background": "./data/img/background/PC教員引き出し-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "多分不要だろう。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 19
            }
        ]
    },
    {
        "id": 27,
        "background": "./data/img/background/本館廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "本館廊下",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 28
            }
        ],
        "alternateScenes": {
            "あ": {
                "background": "./data/img/background/南館-廊下.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "3F 南館",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "./data/se/スイッチ.m4a",
                "textTickSFX": "",
                "choices": [
                    {
                        "text": "次へ",
                        "nextScene": 34
                    }
                ]
            }
        }
    },
    {
        "id": 28,
        "background": "./data/img/background/本館廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "本館行きの廊下は鍵がかかっている。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/鍵付きのドア.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "戻る",
                "nextScene": 15
            }
        ]
    },
    {
        "id": 29,
        "background": "./data/img/background/多目的室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "多目的室",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/引き戸.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 30
            },
            {
                "text": "戻る",
                "nextScene": 15
            }
        ]
    },
    {
        "id": 30,
        "background": "./data/img/background/多目的室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "生徒用の机と教卓がある。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "教卓を探る",
                "nextScene": 31
            },
            {
                "text": "生徒用の机を探る",
                "nextScene": 32
            },
            {
                "text": "退室",
                "nextScene": 15
            }
        ]
    },
    {
        "id": 31,
        "background": "./data/img/background/教卓-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "教卓の中には\"19590964\"付箋が貼ってある。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 30
            }
        ]
    },
    {
        "id": 32,
        "background": "./data/img/background/生徒用机.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "........",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 33
            }
        ]
    },
    {
        "id": 33,
        "background": "./data/img/background/生徒用机.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "特には何もないようだ",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 30
            }
        ]
    },
    {
        "id": 34,
        "background": "./data/img/background/南館マップ.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "南館は工業科の校舎だな。\nここまで鍵が見つかってないし、もう少し捜索範囲広げるか。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 35
            }
        ],
        "alternateScenes": {
            "南館a": {
                "background": "./data/img/background/南館マップ.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "南館は工業科の校舎だな。",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "",
                "textTickSFX": "./data/se/text-se/会話音１.m4a",
                "choices": [
                    {
                        "text": "次へ",
                        "nextScene": 35
                    }
                ]
            }
        }
    },
    {
        "id": 35,
        "background": "./data/img/background/南館-廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "と言っても学科が違うから期待はできないな…",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "K21",
                "nextScene": 36
            },
            {
                "text": "K22",
                "nextScene": 42
            },
            {
                "text": "本館に戻る",
                "nextScene": 15
            }
        ],
        "alternateScenes": {
            "南館a": {
                "background": "./data/img/background/南館-廊下.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "どこから行こうか",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "",
                "textTickSFX": "./data/se/text-se/会話音１.m4a",
                "choices": [
                    {
                        "text": "K21",
                        "nextScene": 36
                    },
                    {
                        "text": "K22",
                        "nextScene": 42
                    },
                    {
                        "text": "本館に戻る",
                        "nextScene": 15
                    }
                ]
            }
        }
    },
    {
        "id": 36,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "K21 教室",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/引き戸.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 37
            }
        ]
    },
    {
        "id": 37,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "どこを探ろうか",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "教卓",
                "nextScene": 38
            },
            {
                "text": "退室",
                "nextScene": 34
            }
        ]
    },
    {
        "id": 38,
        "background": "./data/img/background/教卓-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "中は大学のパンフレットと定期テストの時間割か。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 39
            }
        ],
        "alternateScenes": {
            "ソフトウェア室棚": {
                "background": "./data/img/background/教卓-EDIT.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "中は併設大のパンフレットと定期テストの時間割か。",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "",
                "textTickSFX": "./data/se/text-se/会話音１.m4a",
                "choices": [
                    {
                        "text": "次へ",
                        "nextScene": 37
                    }
                ]
            }
        }
    },
    {
        "id": 39,
        "background": "./data/img/background/教卓-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "赤い札が付いた鍵がある",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "取る",
                "nextScene": 40
            },
            {
                "text": "やめておく",
                "nextScene": 41
            }
        ]
    },
    {
        "id": 40,
        "background": "./data/img/background/教卓-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "赤い札が付いた鍵を入手した。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/黒板ひっかき.mp3",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 37
            }
        ]
    },
    {
        "id": 41,
        "background": "./data/img/background/教卓-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "やめておこう…",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 37
            }
        ]
    },
    {
        "id": 42,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "K22 教室",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/引き戸.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 43
            }
        ],
        "alternateScenes": {
            "K22": {
                "background": "./data/img/background/教室.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "K22 教室",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "./data/se/泥.mp3",
                "textTickSFX": "",
                "choices": [
                    {
                        "text": "次へ",
                        "nextScene": 43
                    }
                ]
            }
        }
    },
    {
        "id": 43,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "どこを探ろうか",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "教卓",
                "nextScene": 44
            },
            {
                "text": "退室",
                "nextScene": 34
            }
        ]
    },
    {
        "id": 44,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "中は.......    泥？",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 45
            }
        ]
    },
    {
        "id": 45,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "素行が悪いのか、、、？    だとしてもこんなことするか？普通",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 43
            }
        ]
    },
    {
        "id": 46,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "もう帰らないとな。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 66
            }
        ]
    },
    {
        "id": 47,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "棚を開けますか？",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "開ける",
                "nextScene": 49
            },
            {
                "text": "やめておく",
                "nextScene": 48
            }
        ]
    },
    {
        "id": 48,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "やめておこう…",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "戻る",
                "nextScene": 19
            }
        ]
    },
    {
        "id": 49,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "棚を開けた",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 50
            }
        ]
    },
    {
        "id": 50,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "中からドキュメントが出てきた。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 51
            }
        ]
    },
    {
        "id": 51,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "ドキュメントは伊勢湾台風について書かれている。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 52
            }
        ]
    },
    {
        "id": 52,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "災害録",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 53
            }
        ]
    },
    {
        "id": 53,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "1959年9月26日に発生した伊勢湾台風は、名古屋市南区を含む広範な地域に甚大な被害をもたらしました。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 54
            }
        ]
    },
    {
        "id": 54,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "当時、大同工業高校（現・大同大学大同高等学校）の生徒たちは、地域の救援活動に積極的に参加し、その献身的な行動は高く評価されています。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 55
            }
        ]
    },
    {
        "id": 55,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "伊勢湾台風の直後、大同工業高校の生徒たちは「救援生徒隊」を結成し、流木となった丸太を集めて救助用の筏を製作しました。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 56
            }
        ]
    },
    {
        "id": 56,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "彼らはこの筏を用いて、浸水した地域での人命救助や物資輸送、傷病者の救護、遺体の回収、避難民の支援など、多岐にわたる活動を展開しました。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 57
            }
        ]
    },
    {
        "id": 57,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "これらの生徒たちの献身的な活動を称え、学校敷地内には「愛と力の筏」と名付けられたブロンズ像が建立されました。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 58
            }
        ]
    },
    {
        "id": 58,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "この像は、名古屋出身の彫刻家・野々村一男氏によって制作され、台座には当時の高潮水位が刻まれています。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 59
            }
        ]
    },
    {
        "id": 59,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "また、銘板には伊勢湾台風時の高潮の状況や生徒たちの活動内容が記されています。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 60
            }
        ]
    },
    {
        "id": 60,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "さらに、当時の教員であった横井時秀氏が撮影した被災直後の映像が発見されました。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 61
            }
        ]
    },
    {
        "id": 61,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "この映像には、大同工業高校の屋上から撮影された救助ヘリコプターの飛行や、浸水した周辺地域で筏を漕ぐ学校関係者の姿が収められており、被災状況をリアルに伝える貴重な資料となっています。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 62
            }
        ]
    },
    {
        "id": 62,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "大同高校の生徒たちの行動は、地域社会との強い結びつきと連帯の精神を示すものであり、災害時における若者の力と意志の重要性を物語っています。",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 63
            }
        ]
    },
    {
        "id": 63,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "./data/se/本.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 64
            }
        ]
    },
    {
        "id": 64,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "....................",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 65
            }
        ]
    },
    {
        "id": 65,
        "background": "./data/img/background/部室1-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/文書.png",
        "defaultRightCharacter": "",
        "dialogue": "この時の大同生がものすごくまともに見えるが錯覚だろうか？",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 19
            }
        ]
    },
    {
        "id": 66,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "結局、鍵はないし、何なんだよ",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 67
            }
        ],
        "alternateScenes": {
            "K22": {
                "background": "./data/img/background/職員室-EDIT.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "そういえばさっき校舎の中で足音が聞こえたような？",
                "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
                "sfx": "",
                "textTickSFX": "./data/se/text-se/会話音１.m4a",
                "choices": [
                    {
                        "text": "次へ",
                        "nextScene": 69
                    }
                ]
            }
        }
    },
    {
        "id": 67,
        "background": "./data/img/background/校舎-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "次の日、鍵は私のデスクに置かれていた",
        "bgm": "",
        "sfx": "./data/se/スイッチ1.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "END",
                "nextScene": 68
            }
        ],
        "alternateScenes": {
            "K221": {
                "background": "./data/img/background/校舎-EDIT.jpg",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "次の日、K22の担任の先生に聞いた話、教卓に詰められてた泥は初めから無く、教卓内のプリントも汚れていなかったそうだ。",
                "bgm": "",
                "sfx": "./data/se/スイッチ.m4a",
                "textTickSFX": "",
                "choices": [
                    {
                        "text": "END",
                        "nextScene": 68
                    }
                ]
            }
        }
    },
    {
        "id": 68,
        "background": "",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "　　　　　　　　　　　　　　エンディング０：鍵が旅立った\n\n　　　　　　　　　　　　　　F5キーでゲームリセット",
        "bgm": "",
        "sfx": "./data/se/ピッ！.m4a",
        "textTickSFX": "",
        "choices": [],
        "alternateScenes": {
            "K221": {
                "background": "",
                "defaultLeftCharacter": "",
                "defaultCenterCharacter": "",
                "defaultRightCharacter": "",
                "dialogue": "　　　　　　エンディング１：教卓の泥詰めは結局誰の仕業だったのか？\n\n　　　　　　　　　　　　　　F5キーでゲームリセット",
                "bgm": "",
                "sfx": "./data/se/レーザー.m4a",
                "textTickSFX": "",
                "choices": []
            }
        }
    },
    {
        "id": 69,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": ".......もしかしてまだ生徒が校舎の中に？",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 70
            }
        ]
    },
    {
        "id": 70,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "どうしようか？",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "戻って探す",
                "nextScene": 72
            },
            {
                "text": "そのまま帰る",
                "nextScene": 71
            }
        ]
    },
    {
        "id": 71,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "なんか、、、不気味だ、まっすぐ帰ろう",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 67
            }
        ]
    },
    {
        "id": 72,
        "background": "./data/img/background/職員室-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "生徒が校舎の中に居たらマズいな…       \n探しに行こう",
        "bgm": "./data/bgm/生暖かい空気 -Tepid air- 【ホラー⧸不気味】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 73
            }
        ]
    },
    {
        "id": 73,
        "background": "",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "思い返せば、ここで引き返すべきだったのかもしれない。          ",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 74
            }
        ]
    },
    {
        "id": 74,
        "background": "./data/img/background/南館-廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "南館 3F",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 75
            }
        ]
    },
    {
        "id": 75,
        "background": "./data/img/background/工業科-廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "確か、足音はこのへ峨＠縺ｦ縺?◆気がする…",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 76
            }
        ]
    },
    {
        "id": 76,
        "background": "./data/img/background/工業科-廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "うぉっ！？         \n泥が廊下にも垂れている....    ",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 77
            }
        ]
    },
    {
        "id": 77,
        "background": "./data/img/background/工業科-廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "泥、、、さっきK22の教卓にも詰められていたが、     ",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 78
            }
        ]
    },
    {
        "id": 78,
        "background": "./data/img/background/工業科-廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "見落としていたのか？",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 79
            }
        ]
    },
    {
        "id": 79,
        "background": "./data/img/background/工業科-廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "泥はK22からK21に、更に南館の階段に続いている",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 80
            }
        ]
    },
    {
        "id": 80,
        "background": "./data/img/background/工業科-廊下.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "とにかく泥をたどってみよう",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "K21",
                "nextScene": 81
            },
            {
                "text": "K22",
                "nextScene": 84
            },
            {
                "text": "階段",
                "nextScene": 85
            }
        ]
    },
    {
        "id": 81,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "K21 教室",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "./data/se/引き戸.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 82
            }
        ]
    },
    {
        "id": 82,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "....................",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 83
            }
        ]
    },
    {
        "id": 83,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "泥が教室中に広がってる......   \nせめて玄関マットで泥は落としてほしいわ、、",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 79
            }
        ]
    },
    {
        "id": 84,
        "background": "./data/img/background/教室.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "K22 教室",
        "bgm": "./data/bgm/深淵の響き【大同高校⧸Original BGM】.mp3",
        "sfx": "./data/se/引き戸.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 82
            }
        ]
    },
    {
        "id": 85,
        "background": "./data/img/background/階段-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "南館 階段",
        "bgm": "",
        "sfx": "./data/se/スイッチ.m4a",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 86
            }
        ]
    },
    {
        "id": 86,
        "background": "./data/img/background/階段-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "階段の踊り場で途切れてる…",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 87
            }
        ]
    },
    {
        "id": 87,
        "background": "./data/img/background/階段-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "まぁ、誰か居たところでイエローカード切ればいいだけだし\n泥を片付けるのも面倒くさい、   ",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 88
            }
        ]
    },
    {
        "id": 88,
        "background": "./data/img/background/階段-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "...............帰るか     ",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 89
            }
        ]
    },
    {
        "id": 89,
        "background": "",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "          \n...............ん？",
        "bgm": "",
        "sfx": "./data/se/足音.ogg",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 90
            }
        ]
    },
    {
        "id": 90,
        "background": "./data/img/background/濁流-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "うわぁぁぁぁぁっぁっぁっぁぁっ！！！！！！！！！！！",
        "bgm": "",
        "sfx": "./data/se/大量の血-シャイニングより-.mp3",
        "textTickSFX": "",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 91
            }
        ]
    },
    {
        "id": 91,
        "background": "",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "▽",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音：タイプライター.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 92
            }
        ]
    },
    {
        "id": 92,
        "background": "./data/img/background/校舎-EDIT.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/工業科-先生.png",
        "defaultRightCharacter": "",
        "dialogue": "後で聞いた話だが、伊勢湾台風の被害に遭って亡くなった方の遺体を校舎の中に安置していたそうだ。",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 93
            }
        ]
    },
    {
        "id": 93,
        "background": "./data/img/background/伊勢湾台風.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "./data/img/character/工業科-先生.png",
        "dialogue": "階段から大量に流れ出した泥水は伊勢湾台風と関連のある怪奇現象だとか",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 94
            }
        ]
    },
    {
        "id": 94,
        "background": "./data/img/background/部室1.jpg",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "./data/img/character/工業科-先生.png",
        "defaultRightCharacter": "",
        "dialogue": "いやぁ、本当に",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": null
            }
        ]
    },
    {
        "id": 95,
        "background": "",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "不気味な体験だったなぁ",
        "bgm": "",
        "sfx": "",
        "textTickSFX": "./data/se/text-se/会話音１.m4a",
        "choices": [
            {
                "text": "次へ",
                "nextScene": 98
            }
        ]
    },
    {
        "id": 96,
        "background": "",
        "defaultLeftCharacter": "",
        "defaultCenterCharacter": "",
        "defaultRightCharacter": "",
        "dialogue": "　　  　　　　　　　　　　　エンディング２：心霊現象\n\n　　　　　　　　　　　　　　F5キーでゲームリセット",
        "bgm": "",
        "sfx": "./data/se/本.m4a",
        "textTickSFX": "",
        "choices": []
    }
];

function showScene(index) {
    const scene = scenes.find(s => s.id === index);
    if (!scene) {
        console.error("Scene not found:", index);
        return;
    }
    currentSceneId = scene.id;

    // --- Generated Switch Logic ---
    
    if (scene.id === 29) {
        gameVariables.scene2VisitedCount++;
    }
    if (gameVariables.scene2VisitedCount >= 7) {
        setSwitch('泥', true);
        
    }
    if (scene.id === 25) {
        gameVariables.scene1VisitedCount++;
    }
    if (gameVariables.scene1VisitedCount >= 1) {
        setSwitch('あ', true);
        
    }
    if (scene.id === 40) {
        gameVariables.scene3VisitedCount++;
    }
    if (gameVariables.scene3VisitedCount >= 1) {
        setSwitch('ソフトウェア室棚', true);
        
    }
    if (scene.id === 25) {
        gameVariables.scene1VisitedCount++;
    }
    if (gameVariables.scene1VisitedCount >= 1) {
        setSwitch('あ', true);
        
    }
    if (scene.id === 25) {
        gameVariables.scene1VisitedCount++;
    }
    if (gameVariables.scene1VisitedCount >= 1) {
        setSwitch('あ', true);
        
    }
    if (scene.id === 34) {
        gameVariables.scene4VisitedCount++;
    }
    if (gameVariables.scene4VisitedCount >= 2) {
        setSwitch('南館a', true);
        
    }
    if (scene.id === 34) {
        gameVariables.scene4VisitedCount++;
    }
    if (gameVariables.scene4VisitedCount >= 2) {
        setSwitch('南館a', true);
        
    }
    if (scene.id === 40) {
        gameVariables.scene3VisitedCount++;
    }
    if (gameVariables.scene3VisitedCount >= 1) {
        setSwitch('ソフトウェア室棚', true);
        
    }
    if (scene.id === 44) {
        gameVariables.scene4VisitedCount++;
    }
    if (gameVariables.scene4VisitedCount >= 3) {
        setSwitch('K22', true);
        
    }
    if (scene.id === 44) {
        gameVariables.scene4VisitedCount++;
    }
    if (gameVariables.scene4VisitedCount >= 3) {
        setSwitch('K22', true);
        
    }
    if (scene.id === 44) {
        gameVariables.scene6VisitedCount++;
    }
    if (gameVariables.scene6VisitedCount >= 1) {
        setSwitch('K221', true);
        
    }
    if (scene.id === 44) {
        gameVariables.scene6VisitedCount++;
    }
    if (gameVariables.scene6VisitedCount >= 1) {
        setSwitch('K221', true);
        
    }
    // ------------------------------

    if (scene.alternateScenes) {
        for (let key in scene.alternateScenes) {
            if (switches[key]) {
                const alternateScene = scene.alternateScenes[key];
                scene.background = alternateScene.background;
                scene.defaultLeftCharacter = alternateScene.defaultLeftCharacter;
                scene.defaultCenterCharacter = alternateScene.defaultCenterCharacter;
                scene.defaultRightCharacter = alternateScene.defaultRightCharacter;
                scene.dialogue = alternateScene.dialogue;
                scene.bgm = alternateScene.bgm;
                scene.sfx = alternateScene.sfx;
                scene.textTickSFX = alternateScene.textTickSFX;
                scene.choices = alternateScene.choices;
                break;
            }
        }
    }

    document.getElementById('background').style.backgroundImage = scene.background ? `url(${scene.background})` : 'none';
    document.getElementById('left-character').style.backgroundImage = scene.defaultLeftCharacter ? `url(${scene.defaultLeftCharacter})` : 'none';
    document.getElementById('center-character').style.backgroundImage = scene.defaultCenterCharacter ? `url(${scene.defaultCenterCharacter})` : 'none';
    document.getElementById('right-character').style.backgroundImage = scene.defaultRightCharacter ? `url(${scene.defaultRightCharacter})` : 'none';
    
    changeBGM(scene.bgm);
    playSFX(scene.sfx);
    typeDialogue(scene.dialogue, scene.textTickSFX, () => {
        if (scene.choices.length > 0) {
            showChoices(scene.choices);
        }
    });
}

function setSwitch(switchName, state) {
    if (switches.hasOwnProperty(switchName)) {
        switches[switchName] = state;
    }
}

function changeBGM(bgm) {
    if (bgm === currentBGM) {
        if(bgm && bgmElement.paused) bgmElement.play().catch(err => console.error(err));
    } else {
        fadeOut(bgmElement, () => {
            if(bgm) {
                bgmElement.src = bgm;
                bgmElement.currentTime = 0;
                bgmElement.play().catch(err => console.error("BGM play error:", err));
                fadeIn(bgmElement);
                currentBGM = bgm;
                bgmPosition = 0;
            } else {
                bgmElement.pause();
                currentBGM = '';
            }
        });
    }
}

function fadeIn(audioElement) {
    let volume = 0;
    audioElement.volume = volume;
    const fadeInInterval = setInterval(() => {
        if (volume < 1) {
            volume += 0.1;
            if(volume > 1) volume = 1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeInInterval);
        }
    }, 100);
}

function fadeOut(audioElement, callback) {
    let volume = audioElement.volume;
    const fadeOutInterval = setInterval(() => {
        if (volume > 0) {
            volume -= 0.1;
            if(volume < 0) volume = 0;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeOutInterval);
            callback();
        }
    }, 100);
}

function playSFX(sfx) {
    if (sfx) {
        const sfxElement = new Audio(sfx);
        sfxElement.play().catch(err => console.error("SFX play error:", err));
    }
}

bgmElement.addEventListener('timeupdate', () => {
    bgmPosition = bgmElement.currentTime;
});

function typeDialogue(text, textTickSFX, callback) {
    const dialogueText = document.getElementById('dialogue-text');
    dialogueText.textContent = '';
    if(!text) {
        if(callback) callback();
        return;
    }
    let i = 0;
    const typingSpeed = 60;
    const interval = setInterval(() => {
        if (i < text.length) {
            dialogueText.textContent += text.charAt(i);
            if (textTickSFX && text.charAt(i).trim() !== '') {
                const tickSFX = new Audio(textTickSFX);
                tickSFX.volume = 0.5; 
                tickSFX.play().catch(err => console.error("Text tick SFX play error:", err));
            }
            i++;
        } else {
            clearInterval(interval);
            setTimeout(callback, 500);
        }
    }, typingSpeed);
}

function showChoices(choices) {
    const choicesContainer = document.getElementById('choices');
    choicesContainer.style.display = 'block';
    choicesContainer.innerHTML = '';
    choices.forEach(choice => {
        const button = document.createElement('button');
        button.className = 'choice-button';
        button.textContent = choice.text;
        button.addEventListener('click', () => {
            choicesContainer.style.display = 'none';
            showScene(choice.nextScene);
        });
        choicesContainer.appendChild(button);
    });
}